import type { ComponentPageScheme } from "jit";
import { Jit } from "jit";
import schemeJson from "./scheme.json";
type BaseComponent = InstanceType<typeof Jit.BaseComponent>;

class PageCls extends Jit.GridPage {
    Form4!: BaseComponent;
    Modal3!: BaseComponent;
    Gallery2!: BaseComponent;
    Filter1!: BaseComponent;
    scheme: ComponentPageScheme = schemeJson;

    bindEvent() {
        this.Gallery2.subscribeEvent("clickCard", async () => {
            this.Modal3.call(undefined);
            this.Form4.formData.value = this.Gallery2.activeRow.value;
            this.Form4.mode.value = "edit";
        });

        this.subscribeEvent("AI:uiinterrupt_mtKTaN.interrupt", async (
            {
                data
            }
        ) => {
            this.Form4.formData.detailsOfResponses.value = data.outputArg1.value;
            this.Form4.formData.comments.value = data.outputArg2.value;
            this.Form4.formData.status.value = "finished";
            this.Form4.formData.score.value = this.Form4.formData.detailsOfResponses.score.sum;
        });

        this.Form4.subscribeEvent("DAuskL", async () => {
            this.sendAiMessage((CONCAT(
                "请针对ID为",
                this.Form4.detailsOfResponsesselectedRows.id.value,
                "的题目重新评分，然后再给我所有题目的评分"
            )), null);
        });

        this.Form4.subscribeEvent("kmAOlH", async () => {
            this.sendAiMessage("给当前试卷打分", 1);
        });

        this.subscribeEvent("AI:uiinterrupt_GpUrXz.interrupt", async (
            {
                data
            }
        ) => {
            this.Form4.formData.detailsOfResponses.value = data.outputArg1.value;
            this.Form4.formData.comments.value = data.outputArg2.value;
            this.Form4.formData.score.value = this.Form4.formData.detailsOfResponses.score.sum;
        });

        this.Form4.subscribeEvent("detailsOfResponses-score-change", async () => {
            this.Form4.formData.score.value = this.Form4.formData.detailsOfResponses.score.sum;
        });

        this.Form4.subscribeEvent("afterSubmit", async () => {
            this.Modal3.close();
            await this.Gallery2.call(undefined);
        });

        this.Filter1.subscribeEvent("afterFilter", async () => {
            await this.Gallery2.call(this.Filter1.filter.value);
        });
    }
}

export default PageCls;