
import { Jit, ComponentPageScheme } from "jit";
import schemeJson from "./scheme.json";

class PageCls extends Jit.GridPage {
    EditForm8!: BaseComponent;
    Modal7!: BaseComponent;
    Import6: BaseComponent;
    Modal5: BaseComponent;
    Filter4!: BaseComponent;
    Form3!: BaseComponent;
    Modal2!: BaseComponent;
    Table1!: BaseComponent;
    scheme: ComponentPageScheme = schemeJson;
    bindEvent() {
        this.Table1.subscribeEvent("clickAdd", async () => {
        this.Modal2.call("新增");
        this.Form3.formData.reset();
        this.Form3.mode.value = "add";
    });this.Table1.subscribeEvent("clickBatchEdit", async () => {
        if (this.Table1.selectedRowList.isNull()) {
            this.app.modules.FeedBack.globalMessage("warn", "请先勾选要修改的行数据");
        } else if (this.Table1.selectedRowList.isNotNull()) {
            this.Modal7.call("批量修改");
            this.EditForm8.formData.reset();
            this.EditForm8.editRowList.value = this.Table1.selectedRowList.value;
        }
    });this.Table1.subscribeEvent("clickBatchDelete", async () => {
        const globalConfirmResult1 = await this.newVariable({
            "name": "globalConfirmResult1",
            "title": "删除提示",
            "dataType": "Dropdown",
            "options": [{
                "value": "true",
                "label": "确定"
            }, {
                "value": "false",
                "label": "取消"
            }]
        }, await this.app.modules.FeedBack.globalConfirm("确定删除这些数据吗？删除后不可恢复"));

        if (globalConfirmResult1.isEqual("true")) {
            const RowList1 = await this.newVariable({
                "name": "RowList1",
                "title": "多行数据1",
                "dataType": "RowList",
                "generic": "models.QuestionModel",
            }, this.Table1.selectedRowList.value);
            await RowList1.delete();
            await this.Table1.call(undefined);
        }
    });this.Table1.subscribeEvent("clickImport", async () => {
        this.Modal5.call("导入");
    });this.Table1.subscribeEvent("clickEdit", async () => {
        this.Modal2.call("编辑");
        this.Form3.mode.value = "edit";
        this.Form3.formData.value = this.Table1.activeRow.value;
    });this.Table1.subscribeEvent("clickDelete", async () => {
        const globalConfirmResult2 = await this.newVariable({
            "name": "globalConfirmResult2",
            "title": "删除提示",
            "dataType": "Dropdown",
            "options": [{
                "value": "true",
                "label": "确定"
            }, {
                "value": "false",
                "label": "取消"
            }]
        }, await this.app.modules.FeedBack.globalConfirm("确定删除这条数据吗？删除后不可恢复"));

        if (globalConfirmResult2.isEqual("true")) {
            await this.Table1.activeRow.delete();
            await this.Table1.call(undefined);
        }
    });this.Table1.subscribeEvent("clickRow", async () => {
        this.Modal2.call("查看");
        this.Form3.mode.value = "read";
        this.Form3.formData.value = this.Table1.activeRow.value;
    });this.Table1.subscribeEvent("selectedChange", async () => {

    });this.Form3.subscribeEvent("afterSubmit", async () => {
        this.Modal2.close();
        await this.Table1.call(undefined);
    });this.Form3.subscribeEvent("beforeSubmit", async () => {

    });this.Form3.subscribeEvent("afterCall", async () => {

    });this.EditForm8.subscribeEvent("afterSubmit", async () => {
        this.Modal7.close();
        await this.Table1.call(undefined);
    });this.Filter4.subscribeEvent("afterFilter", async () => {
        await this.Table1.call(this.Filter4.filter.value);
    });this.Import6.subscribeEvent("clickFinishBtn", async () => {
        this.Modal5.close();
        await this.Table1.call(undefined);
    });this.subscribeEvent("AI:aiagent_datamanager.afterNodeRun", async ({ data }: { data: Record<string, any> }) => {
        if (data.outputArg1.isIn(["新增数据", "修改数据", "删除数据"])) {
            await this.Table1.call(undefined);
        }
    });
    }
}

export default PageCls;
