
from models.NormalType import NormalModel
from datatypes.Meta import datatypes

class responseModel(NormalModel):

    id = datatypes.AutoInt(name = "id" , title = "ID" , primaryKey = True , readOnly = 1)
    examiner = datatypes.Member(title = "Excaminee" , name = "examiner" , createDefault = False , autoAssign = False , readOnly = 0 , default = None , formula = "")
    dateOfExamination = datatypes.Date(title = "Date of Examination" , formatDate = "YYYY-MM-DD" , dateTimeType = "DAY" , name = "dateOfExamination" , dateTimeFormat = "YYYY-MM-DD" , createDefault = False , updateDefault = False , autoAssign = False , readOnly = 0 , default = None , formula = "")
    testPapers = datatypes.RelateData(title = "Test Paper" , name = "testPapers" , relateType = "mto" , generic = "models.testTable" , relateField = "id" , relateFieldType = "AutoInt")
    otherOrganiser = datatypes.Datetime(title = "Start Time" , dateTimeFormat = "YYYY-MM-DD HH:mm:ss" , formatDate = "YYYY-MM-DD" , formatTime = "HH:mm:ss" , dateTimeType = "SECOND" , createDefault = False , updateDefault = False , name = "otherOrganiser")
    submissionTime = datatypes.Datetime(title = "Submission Time" , dateTimeFormat = "YYYY-MM-DD HH:mm:ss" , formatDate = "YYYY-MM-DD" , formatTime = "HH:mm:ss" , dateTimeType = "SECOND" , createDefault = False , updateDefault = False , name = "submissionTime" , autoAssign = False , readOnly = 0 , default = None , formula = "")
    score = datatypes.Numeric(title = "Score" , decimal = 0 , unit = "" , placeholder = "" , name = "score")
    comments = datatypes.Ltext(title = "Comments" , isAllowScan = False , name = "comments")
    status = datatypes.Dropdown(title = "Status" , selectionWay = "custom" , options = [{"label": "unbegun", "value": "unbegun", "style": {"backgroundColor": "#CDE7FF", "color": "#CDE7FF"}}, {"label": "answering ", "value": "answering ", "style": {"backgroundColor": "#DBE1FF", "color": "#DBE1FF"}}, {"label": "answered", "value": "answered", "style": {"backgroundColor": "rgb(254,238,202)", "color": "rgb(254,238,202)"}}, {"label": "finished", "value": "finished", "style": {"backgroundColor": "rgb(189,223,219)", "color": "rgb(189,223,219)"}}] , name = "status" , color = True , placeholder = "" , allowManualInput = False , mulLevelSelectionConfig = {"sortFieldName": "", "sortBy": "", "matchFieldName": "", "dataSourceModel": "", "filterValue": ""})
    detailsOfResponses = datatypes.SubTable(title = "Details of Responses" , name = "detailsOfResponses" , relateField = "relateResponses" , relateFieldType = "RelateData" , generic = "models.responseDetailModel" , relateType = "sub")

    class Meta:
        modelType = "NormalType"
        db = "databases.Default"
        dataTitle = None
        dbTable = "responseModel"
        name = "responseModel"
        baseModel = ""
        unionIndexList = []
        unionUniqueList = []
        