import type { ComponentPageScheme } from "jit";
import { Jit } from "jit";
import schemeJson from "./scheme.json";
type BaseComponent = InstanceType<typeof Jit.BaseComponent>;

class PageCls extends Jit.GridPage {
    Form4!: BaseComponent;
    Modal3!: BaseComponent;
    Gallery2!: BaseComponent;
    Filter1!: BaseComponent;
    scheme: ComponentPageScheme = schemeJson;

    bindEvent() {
        this.Gallery2.subscribeEvent("clickCard", async () => {
            this.Modal3.call(undefined);
            this.Form4.formData.value = this.Gallery2.activeRow.value;
            this.Form4.mode.value = "edit";
        });

        this.subscribeEvent("AI:uiinterrupt_swJrVg.interrupt", async (
            {
                data
            }
        ) => {
            this.Form4.formData.detailsOfResponses.value = data.outputArg1.value;
            this.Form4.formData.comments.value = data.outputArg2.value;
            this.Form4.formData.status.value = "finished";
            this.Form4.formData.score.value = this.Form4.formData.detailsOfResponses.score.sum;
        });

        this.Form4.subscribeEvent("DAuskL", async () => {
            this.sendAiMessage((CONCAT(
                "The score for the question with ID",
                this.Form4.detailsOfResponsesselectedRows.id.value,
                " not very reasonable. Please re-evaluate it, and then provide me with the scores for all questions."
            )), null);
        });

        this.Form4.subscribeEvent("kmAOlH", async () => {
            this.sendAiMessage("Grade the current exam paper", 1);
        });

        this.Form4.subscribeEvent("detailsOfResponses-score-change", async () => {
            this.Form4.formData.score.value = this.Form4.formData.detailsOfResponses.score.sum;
        });

        this.Form4.subscribeEvent("afterSubmit", async () => {
            this.Modal3.close();
            await this.Gallery2.call(undefined);
        });

        this.Filter1.subscribeEvent("afterFilter", async () => {
            await this.Gallery2.call(this.Filter1.filter.value);
        });
    }
}

export default PageCls;